from bpy.types import PropertyGroup, Collection
from bpy.props import FloatProperty, BoolProperty, EnumProperty, PointerProperty
from ..updaters.props_update_mesh_settings import props_update_mesh_settings

class ActiveMeshItemSettingsProps(PropertyGroup):

    """ Propiedades guardadas en el mesh_item.settings.x """

    min_max_expand: BoolProperty(
        name="Toggle Min Max",
        default=False
    )
    min_max_value: FloatProperty(
        name="Min and Max",
        description="Min and Max Voxel Resolution",
        default=0.05,
        min=0,
        update=lambda self, context: props_update_mesh_settings(self, context, "min_max_value")
    )
    collection_grains: PointerProperty(
        name="Collection Grains",
        description="Specify one collection for your grains",
        type=Collection,
        update=lambda self, context: props_update_mesh_settings(self, context, "collection_grains")
    )
    

    p_or_g: EnumProperty(
        items=[
                ('1', "Points", "", 0),
                ('0', "Geometry", "", 1),
        ],
        default='1',
        update=lambda self, context: props_update_mesh_settings(self, context, "p_or_g")
    )

    subsections: EnumProperty(
        items=[
            ('FLUID', "Fluid", "", "MATFLUID", 0),
            ('GRAIN', "Grain", "", "LIGHTPROBE_VOLUME", 1),
        ],
        default='FLUID'
    )
    



    def get_default_properties(self, target_prop):
        for prop in self.bl_rna.properties:
            if prop.identifier == target_prop:
                if hasattr(prop, "default"):
                    return prop.default